/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.sysinfo;

import com.ibm.hwmca.base.sysinfo.SysInfoConstants;
import com.ibm.hwmca.base.sysinfo.SysInfoEcData;
import com.ibm.hwmca.base.sysinfo.SysInfoEcInternalCodeData;
import com.ibm.hwmca.base.sysinfo.SysInfoErrorIds;
import com.ibm.hwmca.base.sysinfo.SysInfoMclData;
import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.vpdmgr.VpdConfigurationData;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdManagerException;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.sysinfo.SysInfoData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SysInfoTowerUtil
implements SysInfoErrorIds,
SysInfoConstants {
    SysInfoEcInternalCodeData internalCode;
    Tower tower;
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-53, "SysInfoTowerUtil");
    private static final String TRACE_MASKT = "HSYITU_T";
    private static final String TRACE_MASKF = "HSYITU_F";
    private static final String TRACE_MASKD = "HSYITU_D";

    public SysInfoTowerUtil(Tower tower) {
        this.tower = tower;
        Trace.trace(TRACE_MASKT, "SysInfoTowerUtil()<-->");
    }

    public SysInfoData getSysInfoData() throws HException {
        SysInfoEcInternalCodeData sysInfo = new SysInfoEcInternalCodeData(this.tower.getObjectId());
        Trace.trace(TRACE_MASKT, "--> SysInfoTowerUtil.getSysInfoData(Tower)");
        VpdData vpdData = new VpdData(VpdRequestValue.CONFIG_REQUEST);
        VpdManager vpd = VpdManager.getVpdManager();
        try {
            vpdData = vpd.callVpdManager(vpdData);
            VpdConfigurationData configData = vpdData.getVpdConfigurationExistData();
            String serialNumber = configData.getMachineSerial();
            sysInfo.setMachineSerialNumber(serialNumber);
            String machType = configData.getMachineType();
            sysInfo.setMachineType(new LocalizableText(machType));
            String machModel = configData.getMachineModel();
            sysInfo.setMachineModel(new LocalizableText(machModel));
            if (User.getUser().hasAuth("base.rolegroup.service")) {
                Trace.trace(TRACE_MASKD, "User has Service Authority - set driver level ");
                sysInfo.setMachineDriverLevel(this.determineDriverLvl());
            } else {
                Trace.trace(TRACE_MASKD, "User DOES NOT have Service Authority - set driver level to NOT_SERVICE ");
                sysInfo.setMachineDriverLevel("Not Service Authority");
            }
        }
        catch (VpdManagerException e) {
            sysInfo.setMachineSerialNumber("Unable to Determine");
            sysInfo.setMachineType(new LocalizableText("Unable to Determine"));
            sysInfo.setMachineModel(new LocalizableText("Unable to Determine"));
            Trace.trace(TRACE_MASKF, "SysInfoTowerUtil - Error getting serial number from VPD: ");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKD, "Set HMC machine serial = " + sysInfo.getMachineSerialNumber());
        Trace.trace(TRACE_MASKD, "Set HMC machine type = " + sysInfo.getMachineType());
        Trace.trace(TRACE_MASKD, "Set HMC machine model = " + sysInfo.getMachineModel());
        HMC hmc = HMC.getHMC();
        sysInfo.setMachineName(hmc.getDisplayableName());
        Trace.trace(TRACE_MASKD, "Set HMC machine name = " + sysInfo.getMachineName());
        Trace.trace(TRACE_MASKD, "Calling buildSysInfoEcData");
        ArrayList ecArrayList = this.buildSysInfoEcData();
        if (!ecArrayList.isEmpty()) {
            Trace.trace(TRACE_MASKD, "Back from buildSysInfoEcData() ");
            Trace.trace(TRACE_MASKD, "Size number of Ec's in ecArrayList is " + ecArrayList.size());
        } else {
            Trace.trace(TRACE_MASKD, "ecArraylist is empty!!!! ");
        }
        sysInfo.setSysInfoEcData(ecArrayList);
        sysInfo.setEcValid(true);
        Trace.trace(TRACE_MASKT, "<--SysInfoTowerUtil.getSysInfoData()");
        return sysInfo;
    }

    public ArrayList buildSysInfoEcData() {
        ArrayList<SysInfoEcData> ecArrayList = new ArrayList<SysInfoEcData>();
        Trace.trace(TRACE_MASKT, "SysInfoTowerUtil.buildSysInfoEcData()--->");
        Trace.trace(TRACE_MASKT, "Tower= " + this.tower);
        UpdateManager um = UpdateManager.getUpdateManager();
        Trace.trace(TRACE_MASKD, "Calling UpdateManager.getComponentByTower(" + this.tower + ")");
        List ecs = um.getComponentsByTower(this.tower);
        Trace.trace(TRACE_MASKD, "Back from UpdateManager.getComponentsByTower()");
        Trace.trace(TRACE_MASKD, "List size = " + ecs.size());
        if (ecs.size() != 0) {
            int dbi = 0;
            Iterator iterator = ecs.iterator();
            while (iterator.hasNext()) {
                ECStream upComp = (ECStream)iterator.next();
                Trace.trace(TRACE_MASKD, "ECStream " + dbi + " = " + upComp);
                String ecPartNumber = upComp.getPartNumber();
                String ecNumber = upComp.getECNumber();
                LocalizableText ecType = new LocalizableText(upComp.getName());
                LocalizableText ecDescription = upComp.getDescription();
                SysInfoEcData sysEc = new SysInfoEcData(ecPartNumber, ecNumber, ecType, ecDescription);
                int level = upComp.getStagedLevel();
                Date date = upComp.getStagedDate();
                SysInfoMclData retrieve = new SysInfoMclData(Integer.toString(level), date);
                sysEc.setRetrieveMclData(retrieve);
                level = upComp.getNonDisruptiveApplyLevel();
                SysInfoMclData ccpInstall = new SysInfoMclData(Integer.toString(level));
                sysEc.setCcpInstallMclData(ccpInstall);
                level = upComp.getAppliedLevel();
                date = upComp.getAppliedDate();
                SysInfoMclData install = new SysInfoMclData(Integer.toString(level), date);
                sysEc.setInstallMclData(install);
                sysEc.setActivatedMclData(install);
                level = upComp.getCommittedLevel();
                date = upComp.getCommittedDate();
                SysInfoMclData accepted = new SysInfoMclData(Integer.toString(level), date);
                sysEc.setAcceptedMclData(accepted);
                level = upComp.getNonDisruptiveRejectLevel();
                SysInfoMclData ccpRemove = new SysInfoMclData(Integer.toString(level));
                sysEc.setCcpRemoveMclData(ccpRemove);
                SysInfoMclData remove = new SysInfoMclData("na");
                sysEc.setRemoveMclData(remove);
                ecArrayList.add(sysEc);
                ++dbi;
            }
        }
        Trace.trace(TRACE_MASKT, "<---SysInfoTowerUtil.buildSysInfoEcData()");
        return ecArrayList;
    }

    private String determineDriverLvl() {
        Trace.trace(TRACE_MASKT, "--> SysInfoTowerUtil.determineDriverLvl()");
        String driverLevel = this.openAndReadDriverNameFile();
        if (driverLevel == null) {
            driverLevel = "Not available";
        }
        Trace.trace(TRACE_MASKF, "Driver Level = " + driverLevel);
        Trace.trace(TRACE_MASKT, "<-- SysInfoTowerUtil.determineDriverLvl()");
        return driverLevel;
    }

    private String openAndReadDriverNameFile() {
        String line;
        block11: {
            String fullFileName = null;
            line = null;
            long fileLength = 0L;
            Trace.trace(TRACE_MASKT, "->openAndReadDriverNameFile");
            try {
                String filePath = BaseFileControl.getFilePath("driver.name");
                Trace.trace(TRACE_MASKF, "filePath for DRIVER_NAME_FILE= " + filePath);
                fullFileName = filePath + "driver.name";
                Trace.trace(TRACE_MASKF, "fullFileName for DRIVER_NAME_FILE= " + fullFileName);
                File driverFile = new File(fullFileName);
                Trace.trace(TRACE_MASKF, "created driverFile object");
                if (driverFile.exists() && driverFile.isFile() && !driverFile.isDirectory() && driverFile.length() > 0L) {
                    Trace.trace(TRACE_MASKF, "driverFile exists & is a file");
                    fileLength = driverFile.length();
                    Trace.trace(TRACE_MASKF, "driverFile length = " + fileLength);
                    BufferedReader in = null;
                    Object out = null;
                    try {
                        in = new BufferedReader(new FileReader(fullFileName));
                        if (in != null) {
                            try {
                                line = in.readLine();
                                if (line != null) {
                                    Trace.trace(TRACE_MASKD, "found file entry [" + line + "]");
                                }
                            }
                            catch (IOException ioexc) {
                                Trace.trace(TRACE_MASKF, "Error reading line from file: " + ioexc.getMessage());
                                new FrameworkLog(logInfo, 81, ioexc).log();
                            }
                            try {
                                in.close();
                            }
                            catch (IOException ioe) {}
                            break block11;
                        }
                        Trace.trace(TRACE_MASKF, "new BufferedReader == null");
                    }
                    catch (IOException ioexc) {
                        Trace.trace(TRACE_MASKF, "Error creating new BufferedReader for Driver Name file: " + ioexc.getMessage());
                        new FrameworkLog(logInfo, 80, ioexc).log();
                    }
                    break block11;
                }
                Trace.trace(TRACE_MASKF, "driver.name file does not exist or is empty");
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKF, "Error getting path to driver.name file: " + he);
            }
        }
        Trace.trace(TRACE_MASKT, "<-openAndReadDriveNameFile");
        return line;
    }
}

